//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Create CR CMP Request
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CMP_CR_FILE "cmp_cr.bin"
#define CMP_RA_CERT "cmp_ra.cer"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
unsigned char Cert[8196];
//------------------------------------------------------------------------------
//        
// :
// 1.   
// 2.       CMP/CR,  
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey,newKey,newKey2,hExpKey;
 DWORD dw,len,sz;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //    ( )
 if (getFileLen(CMP_RA_CERT,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_RA_CERT,Cert,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //    
 if (!CPGetUserKey(hProv,AT_SIGNATURE,&hKey)) {
   printf("CPGetUserKey AT_SIGNATURE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPGenKey(hProv,CALG_EC256_512G_A,CRYPT_EXPORTABLE,&newKey)) {
   printf("CPGenKey CALG_EC256_512G_A Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPGenKey(hProv,CALG_RSA_2048,CRYPT_EXPORTABLE,&newKey2)) {
   printf("CPGenKey CALG_EC256_512G_A Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //     CMP/CR
 if (!CPGenKey(hProv,CALG_CMP_KEY,CRYPT_EXPORTABLE,&hExpKey)) {
   printf("CPGenKey CALG_CMP_KEY Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    CR
 dw=PKI_CMP_CR;
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_TYPE,(BYTE*)&dw,0)) {
   printf("CPSetKeyParam KP_CMP_TYPE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_EXP_KEY,(BYTE*)&hKey,0)) {
   printf("CPSetKeyParam KP_CMP_EXP_KEY Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    ( )
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_RCP_SUBJ,Cert,0)) {
   printf("CPSetKeyParam KP_CMP_RCP_SUBJ Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //     
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_ADD_KEY,(BYTE*)&newKey2,0)) {
   printf("CPSetKeyParam KP_CMP_ADD_KEY Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 len=sizeof(WBuf);
 if (!CPExportKey(hProv,newKey,hExpKey,PUBLICKEYBLOB_CMP,0,WBuf,&len)) {
   printf("CPExportKey PUBLICKEYBLOB_CMP Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(CMP_CR_FILE,WBuf,len);
 //
 CPDestroyKey(hProv,hKey);
 CPDestroyKey(hProv,newKey);
 CPDestroyKey(hProv,newKey2);
 CPDestroyKey(hProv,hExpKey);
 //
 //   
 if (!CPImportKey(hProv,WBuf,len,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  transactionID  
 len=sizeof(WBuf);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_TRANS_ID,WBuf,&len,0)) {
   printf("CPGetKeyParam KP_CMP_TRANS_ID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 WBuf[len]=0;
 printf("transactionID = %s\n",(char*)WBuf);
 CPDestroyKey(hProv,hKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
